// Pivot Setter
//
// @author Hiroto Tsubaki (tg_jp) tg@tres-graficos.jp
//
// Tool script ( ~/Library/Application Support/Cheetah3D/scripts/Tool to install )
//

function buildUI( tool ) {
    
    tool.addParameterSeparator("Pivot Setter");
    
    tool.addParameterFloat("pivot x", 0, -10000, 10000, false, true);
    tool.addParameterFloat("pivot y", 0, -10000, 10000, false, true);
    tool.addParameterFloat("pivot z", 0, -10000, 10000, false, true);
    
    tool.addParameterButton("set pivot", "set", "setPivot");
    
    tool.addParameterSeparator("Helper");
    tool.addParameterButton("get pivot", "get", "getPivotPoisition");
    
    getPivotPoisition( tool );
}

function getPivotPoisition( tool ) {
    
    var obj = tool.document().selectedObject();
    var vec = obj.getParameter("pivot");
    
    tool.setParameter("pivot x", vec.x );
    tool.setParameter("pivot y", vec.y );
    tool.setParameter("pivot z", vec.z );
}

function setPivot( tool ) {
    
    var doc = tool.document();
    var obj = doc.selectedObject();
    
    obj.setParameter("pivot", new Vec3D( tool.getParameter("pivot x"), tool.getParameter("pivot y"), tool.getParameter("pivot z") ) );
    
    obj.update();
}
